class ListItem {
    private ListItem Next = null;
    private int Value = 0;

    public ListItem() {
    }

    public ListItem(int Value) {
        this.Value = Value;
    }

    public int getValue() {
        return Value;
    }

    public void setValue(int Value) {
        this.Value = Value;
    }

    public ListItem getNext() {
        return Next;
    }

    public void setNext(ListItem Next) {
        this.Next = Next;
    }
}

class LinearList {
    private ListItem First = null;

    public boolean empty() {
        return (length() == 0);
    }

    public int length() {
        int r = 0;
        ListItem p = First;

        while (p != null) {
            p = p.getNext();
            r++;
        }

        return r;
    }

    public void clear() {
        First = null;
        System.gc();
    }

    public void append(int Value) {
        if (First == null) First = new ListItem(Value); else {
            ListItem p = First;

            while (p.getNext() != null) p = p.getNext();
            p.setNext(new ListItem(Value));
        }
    }

    public void delete(int Index) {
        if (Index == 0) First = First.getNext(); else {
            int r = 0;
            ListItem p = First, q = First;

            while (p != null) {
                if (r == Index) {
                    q.setNext(p.getNext());
                    break;
                }
                q = p;
                p = p.getNext();
                r++;
            }
        }
    }

    public void insert(int Index, int Value) {
        if (Index == 0) {
            ListItem q = First;
            First = new ListItem(Value);
            First.setNext(q);
        } else {
            int r = 0;
            ListItem p = First, q = First;

            while (p != null) {
                if (r == Index) {
                    ListItem o = new ListItem(Value);
                    o.setNext(p);
                    q.setNext(o);
                    break;
                }
                q = p;
                p = p.getNext();
                r++;
            }
        }
    }

    public int getValue(int Index) {
        int r = 0;
        ListItem p = First;

        while (p != null) {
            if (r == Index) return p.getValue();
            p = p.getNext();
            r++;
        }
        return 0;
    }

    public void setValue(int Index, int Value) {
        int r = 0;
        ListItem p = First;

        while (p != null) {
            if (r == Index) {
                p.setValue(Value);
                break;
            }
            p = p.getNext();
            r++;
        }
    }

    public String toString() {
        String s = "List = (";
        ListItem p = First;

        while (p != null) {
            s += p.getValue() + (p.getNext() != null ? ", " : ")");
            p = p.getNext();
        }
        return s;
    }
}

public class LinList {
    public static void main(String[] args) {
        LinearList myLinearList = new LinearList();

        System.out.println("LinearList Stress Test\n======================\n\n" +
            "Appending 16384 items to empty list...");
        for (int i = 0; i < 16384; i++)
            myLinearList.append(i);
        System.out.println("  - " + myLinearList.length() + " item(s) added.\n");

        System.out.println("Deleting 16383 items from list...");
        for (int i = 16383; i > 0; i--)
            myLinearList.delete(i);
        System.out.println("  - Items deleted, " + myLinearList.length() + " item(s) total.\n");

        System.out.println("Inserting 16384 items to list...");
        for (int i = 0; i < 16384; i++)
            myLinearList.insert(i - 1, i);
        System.out.println("  - Items inserted, " + myLinearList.length() + " item(s) total.\n");

        System.out.println("Now clearing list...");
        myLinearList.clear();
        System.out.println("  - Items cleared, " + myLinearList.length() + " item(s) total.\n");
        System.out.println("All done. Bye, bye!\n");
    }
}
